//Gamma correction
//Scilab 5.4.1
//Windows 10 
//Requires SIVP, IPD toolboxes

clear;
clc;

I=imread('ararauna.png');

gamma_Value = 0.5;
max_intensity = 255; //for uint8 image
//Look up table creation
LUT = max_intensity.*(([0:max_intensity]./max_intensity).^gamma_Value);
LUT = floor(LUT);
//Mapping of input pixels into lookup table values
K = double(I)+1;
J = zeros(I);
[m,n,p]= size(K);
for i = 1:m
 for j =1:n
     for k = 1:p
          J(i,j,k)= LUT(K(i,j,k));
      end
    end
end

imwrite(uint8(J), 'GammaCorrectedImage.jpeg');   //IPD toolbox
